<!DOCTYPE html>
<html lang="en">
<?php include_once("inc/head.php") ?>
<body id="app-container" class="menu-default show-spinner">
  <?php include_once("inc/nav.php"); ?>
  <?php include_once("inc/menu.php"); ?>
  <main>
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
          <h1>Tabela de Serviços Extraordinários</h1>
          <nav class="breadcrumb-container d-none d-sm-block d-lg-inline-block" aria-label="breadcrumb">
            <ol class="breadcrumb pt-0">
              <li class="breadcrumb-item">
                <a href="#">Back Office</a>
              </li>
            </ol>
          </nav>
          <div class="separator mb-5"></div>
        </div>
      </div>
    </div>
    <div class="row sortable">
    </div>
  </div>
</div>

<div class="row">
  <div class="col-md-12 mb-4 col-item">
    <div class="card">
      <div class="card-body pt-5 pb-5">
        <div class="text-center mb-4">
          <i class="iconsminds-calculator large-icon"></i>
          <h5 class="mb-0 font-weight-semibold color-theme-1">CF CONTABILIDADE - ESPECIALISTAS TRABALHANDO POR VOCÊ</h5>
        </div>
        
        <!-- Tabela de Serviços Extraordinários -->
        <div class="table-responsive">
          <table class="table table-striped">
            <thead class="thead-dark">
              <tr>
                <th width="25%">Serviço</th>
                <th width="55%">Descrição</th>
                <th width="20%" class="text-center">Valor</th>
              </tr>
            </thead>
            <tbody>
              <!-- SERVIÇOS EXTRAORDINÁRIOS -->
              <tr class="table-primary">
                <td colspan="3" class="font-weight-bold text-center">SERVIÇOS EXTRAORDINÁRIOS</td>
              </tr>
              
              <tr>
                <td><strong>Alteração Contratual Completa</strong></td>
                <td>Inclui 2 ou mais alterações no contrato: alteração sócios + mudança endereço + alteração do objeto social e atividades. Elaboramos os documentos necessários como (Consulta prévia, Consulta viabilidade, Alteração do Contrato Social etc) + serviço de protocolo do processo físico nos órgãos públicos.</td>
                <td class="text-center font-weight-bold">R$ 500,00</td>
              </tr>
              
              <tr>
                <td><strong>Alteração Contratual Simples</strong></td>
                <td>Uma das seguintes alterações: sócios, endereço, objeto social, atividades ou cláusula específica. Elaboramos os documentos necessários como (Consulta prévia, Consulta viabilidade, Alteração do Contrato Social etc) + serviço de protocolo do processo físico nos órgãos públicos.</td>
                <td class="text-center font-weight-bold">R$ 500,00</td>
              </tr>
              
              <tr>
                <td><strong>Alteração de Natureza Jurídica</strong></td>
                <td>Alteração de Natureza Jurídica (E.I. para LTDA e vice-versa). É cobrado como duas alterações contratuais completas, por serem dois processos registrados concomitantemente.</td>
                <td class="text-center font-weight-bold">R$ 1.000,00</td>
              </tr>
              

              
  
              
              <tr>
                <td><strong>Baixa de Empresa - Lucro Presumido</strong></td>
                <td>Inclui a elaboração da documentação na junta comercial, receita federal e prefeitura + serviço de protocolo do processo físico nos órgãos públicos. Obs.: 1) Não estão inclusos os livros e demais registros contábeis da empresa antes do início da responsabilidade da CF Contabilidade. 2) Não estão inclusas as taxas dos órgãos públicos e despesas de correios e cartórios. 3) Valor sujeito a alteração mediante análise cadastral.</td>
                <td class="text-center font-weight-bold">R$ 1.000,00</td>
              </tr>
              
              <tr>
                <td><strong>Baixa de Empresa - Simples Nacional</strong></td>
                <td>Inclui a elaboração da documentação na junta comercial, receita federal e prefeitura + serviço de protocolo do processo físico nos órgãos públicos. Obs.: 1) Não estão inclusos os livros e demais registros contábeis da empresa antes do início da responsabilidade da CF Contabilidade. 2) Não estão inclusas as taxas dos órgãos públicos e despesas de correios e cartórios.</td>
                <td class="text-center font-weight-bold">R$ 500,00</td>
              </tr>
              
              <!-- SERVIÇOS CONTÁBEIS -->
              <tr class="table-success">
                <td colspan="3" class="font-weight-bold text-center">SERVIÇOS CONTÁBEIS</td>
              </tr>
              
              <tr>
                <td><strong>ECD</strong></td>
                <td>Escrituração Contábil Digital</td>
                <td class="text-center font-weight-bold">R$ 500,00</td>
              </tr>
              
              <tr>
                <td><strong>ECF - Lucro Real</strong></td>
                <td>Escrituração Contábil Fiscal para empresas enquadradas no Lucro Real</td>
                <td class="text-center font-weight-bold">R$ 900,00</td>
              </tr>
              
              <tr>
                <td><strong>ECF - LP/Imune/Isentas</strong></td>
                <td>Escrituração Contábil Fiscal para Lucro Presumido, Imunes e Isentas</td>
                <td class="text-center font-weight-bold">R$ 500,00</td>
              </tr>
              
              <tr>
                <td><strong>ECF Sem Movimento</strong></td>
                <td>Escrituração Contábil Fiscal para empresas sem movimentação</td>
                <td class="text-center font-weight-bold">R$ 250,00</td>
              </tr>
              
              <tr class="table-danger">
                <td><strong>Contabilidade Retroativa</strong></td>
                <td>SIMULAR O ANUAL/TRIMESTRAL NO Sistema de Cálculo do Backoffice</td>
                <td class="text-center font-weight-bold text-danger">SIMULAR</td>
              </tr>
              
              <tr>
                <td><strong>Auditoria Contábil (Parecer Técnico com Opinião)</strong></td>
                <td>Auditoria contábil com parecer técnico e opinião - por ano</td>
                <td class="text-center font-weight-bold">R$ 4.000,00</td>
              </tr>
              
              <tr>
                <td><strong>Balanço de Abertura</strong></td>
                <td>Elaboração de balanço de abertura</td>
                <td class="text-center font-weight-bold">R$ 200,00</td>
              </tr>
              
              <tr>
                <td><strong>Índices/Coeficientes, Notas Explicativas</strong></td>
                <td>Elaboração de índices, coeficientes e notas explicativas</td>
                <td class="text-center font-weight-bold">R$ 300,00</td>
              </tr>
              
              <tr>
                <td><strong>REINF R-4010 - Distribuição de Lucros</strong></td>
                <td>Evento de distribuição de lucros - FIM DA DIRF!</td>
                <td class="text-center font-weight-bold">R$ 250,00</td>
              </tr>
              
              <tr class="table-danger">
                <td><strong>Carnê-Leão</strong></td>
                <td>SIMULAR O ANUAL/TRIMESTRAL NO Sistema de Cálculo do Backoffice</td>
                <td class="text-center font-weight-bold text-danger">SIMULAR</td>
              </tr>
              
              <tr>
                <td><strong>Imposto de Renda Pessoa Física</strong></td>
                <td>Declaração de Imposto de Renda Pessoa Física</td>
                <td class="text-center font-weight-bold">A partir de R$ 200,00 (Simplificado) - R$ 300,00 (Completo)</td>
              </tr>
              

              
              <!-- SERVIÇOS FISCAIS -->
              <tr class="table-warning">
                <td colspan="3" class="font-weight-bold text-center">SERVIÇOS FISCAIS</td>
              </tr>
              
              <tr>
                <td><strong>Declaração do Simples Nacional - SEM MOVIMENTO</strong></td>
                <td>Declaração do Simples Nacional para empresas sem movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 50,00</td>
              </tr>
              
              <tr>
                <td><strong>Declaração do Simples Nacional - COM MOVIMENTO</strong></td>
                <td>Declaração do Simples Nacional para empresas com movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 150,00</td>
              </tr>
              
              <tr>
                <td><strong>DESTDA - SEM MOVIMENTO</strong></td>
                <td>Declaração de Substituição Tributária, Diferencial de Alíquotas e Antecipação sem movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 50,00</td>
              </tr>
              
              <tr>
                <td><strong>DESTDA - COM MOVIMENTO</strong></td>
                <td>Declaração de Substituição Tributária, Diferencial de Alíquotas e Antecipação com movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 150,00</td>
              </tr>
              
              <tr>
                <td><strong>EFD REINF - R-2000 e R-4000 (Retenções)</strong></td>
                <td>Escrituração Fiscal Digital de Retenções e Outras Informações Fiscais - R-2000 e R-4000 (Retenções)</td>
                <td class="text-center font-weight-bold">R$ 150,00</td>
              </tr>
              
              <tr>
                <td><strong>SPED ICMS - SEM MOVIMENTO</strong></td>
                <td>Sistema Público de Escrituração Digital - ICMS sem movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 100,00</td>
              </tr>
              
              <tr>
                <td><strong>SPED ICMS - COM MOVIMENTO</strong></td>
                <td>Sistema Público de Escrituração Digital - ICMS com movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 150,00</td>
              </tr>
              
              <tr>
                <td><strong>SPED CONTRIBUIÇÕES - SEM MOVIMENTO</strong></td>
                <td>Sistema Público de Escrituração Digital - Contribuições sem movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 100,00</td>
              </tr>
              
              <tr>
                <td><strong>SPED CONTRIBUIÇÕES - COM MOVIMENTO</strong></td>
                <td>Sistema Público de Escrituração Digital - Contribuições com movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 150,00</td>
              </tr>
              
              <tr>
                <td><strong>DCTF (Antiga) - SEM MOVIMENTO</strong></td>
                <td>Declaração de Débitos e Créditos Tributários Federais (versão antiga) sem movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 100,00</td>
              </tr>
              
              <tr>
                <td><strong>DCTF (Antiga) - COM MOVIMENTO</strong></td>
                <td>Declaração de Débitos e Créditos Tributários Federais (versão antiga) com movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 150,00</td>
              </tr>
              
              <tr>
                <td><strong>MIT (DCTF Web)</strong></td>
                <td>MIT - DCTF Web (por período)</td>
                <td class="text-center font-weight-bold">R$ 100,00</td>
              </tr>
              
              <tr>
                <td><strong>DEFIS</strong></td>
                <td>Declaração de Informações Socioeconômicas e Fiscais. Há necessidade de envio de algumas informações previamente.</td>
                <td class="text-center font-weight-bold">R$ 150,00</td>
              </tr>
              
              <tr>
                <td><strong>Recálculo de Guia de Empresa Fora do Backoffice</strong></td>
                <td>Recálculo de guia para empresas que não estão no Backoffice</td>
                <td class="text-center font-weight-bold">R$ 40,00</td>
              </tr>
              
              <tr>
                <td><strong>Declarações Estaduais (DOT, DIEF, DIME...) - SEM MOVIMENTO</strong></td>
                <td>Declarações estaduais como DOT, DIEF, DIME sem movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 40,00</td>
              </tr>
              
              <tr>
                <td><strong>Declarações Estaduais (DOT, DIEF, DIME...) - COM MOVIMENTO</strong></td>
                <td>Declarações estaduais como DOT, DIEF, DIME com movimentação (por período)</td>
                <td class="text-center font-weight-bold">R$ 120,00</td>
              </tr>
              
              <tr class="table-danger">
                <td><strong>Apuração de Impostos</strong></td>
                <td>Apuração de Impostos (Precisa de avaliação prévia do movimento/atividade/período)</td>
                <td class="text-center font-weight-bold text-danger">SIMULAR MENSALMENTE</td>
              </tr>
              
              <tr>
                <td><strong>Emissão do Extrato do Simples Nacional</strong></td>
                <td>Geração de informações da empresa dentro do site do Simples Nacional com prazo máximo de 5 anos.</td>
                <td class="text-center font-weight-bold">R$ 50,00</td>
              </tr>
              
              <tr>
                <td><strong>Escrituração Fiscal Convencional (Papel)</strong></td>
                <td>Impressão, assinatura e registro das demonstrações em papel, quando solicitado. Valor correspondente aos livros Diário e Razão, por ano. Obs.: Não estão inclusas as taxas dos órgãos públicos e despesas de correios e cartórios.</td>
                <td class="text-center font-weight-bold">R$ 400,00</td>
              </tr>
              
              <tr>
                <td><strong>Formulários Diversos</strong></td>
                <td>Preenchimento da parte contábil e assinatura pelo profissional habilitado; o custo com envio é a parte.</td>
                <td class="text-center font-weight-bold">R$ 70,00</td>
              </tr>
              
              <tr>
                <td><strong>GFIP - Pro Labore de Mês Anterior</strong></td>
                <td>Entrega de GFIP e geração de recibos de pro labore de período anterior ao cadastro de pro labore na plataforma. Entrega de GFIP em atraso (com movimento) pode gerar multa pela Receita Federal.</td>
                <td class="text-center font-weight-bold">R$ 100,00</td>
              </tr>
              
              <tr>
                <td><strong>Classificação de Produtos</strong></td>
                <td>Classificação de produtos para fins fiscais</td>
                <td class="text-center font-weight-bold">R$ 40,00 por produto</td>
              </tr>
              
              <tr>
                <td><strong>REINF</strong></td>
                <td>EFD-Reinf - Escrituração Fiscal Digital de Retenções e Outras Informações Fiscais</td>
                <td class="text-center font-weight-bold">R$ 150,00</td>
              </tr>
              
              <tr>
                <td><strong>SPED EFD</strong></td>
                <td>Sistema Público de Escrituração Digital - Escrituração Fiscal Digital</td>
                <td class="text-center font-weight-bold">R$ 100,00</td>
              </tr>
              
              <tr>
                <td><strong>DCFT</strong></td>
                <td>Declaração de Débitos e Créditos Tributários Federais</td>
                <td class="text-center font-weight-bold">R$ 100,00</td>
              </tr>
              
              <tr>
                <td><strong>Recálculo FGTS</strong></td>
                <td>Recálculo do Fundo de Garantia por Tempo de Serviço</td>
                <td class="text-center font-weight-bold">R$ 50,00</td>
              </tr>
              
              <tr>
                <td><strong>DCTF WEB</strong></td>
                <td>Declaração de Débitos e Créditos Tributários Federais - Versão Web</td>
                <td class="text-center font-weight-bold">R$ 150,00</td>
              </tr>
              
              <tr>
                <td><strong>EFD REINF</strong></td>
                <td>Escrituração Fiscal Digital de Retenções e Outras Informações Fiscais</td>
                <td class="text-center font-weight-bold">R$ 150,00</td>
              </tr>
              
              <tr>
                <td><strong>SINTEGRA</strong></td>
                <td>Sistema Integrado de Informações sobre Operações Interestaduais com Mercadorias e Serviços</td>
                <td class="text-center font-weight-bold">R$ 80,00</td>
              </tr>
              
              <tr>
                <td><strong>INPI (Cadastro)</strong></td>
                <td>Cadastro de marcas no INPI. Não incluso o valor de Taxas.</td>
                <td class="text-center font-weight-bold">R$ 1.000,00</td>
              </tr>
            </tbody>
          </table>
        </div>
        
        <!-- Nova Tabela para Departamento Pessoal -->
        <div class="table-responsive mt-5">
          <table class="table table-striped">
            <thead class="thead-dark">
              <tr>
                <th width="25%">Serviço</th>
                <th width="55%">Descrição</th>
                <th width="20%" class="text-center">Valor</th>
              </tr>
            </thead>
            <tbody>
              <!-- SERVIÇOS DE DEPARTAMENTO PESSOAL -->
              <tr class="table-info">
                <td colspan="3" class="font-weight-bold text-center">SERVIÇOS DE DEPARTAMENTO PESSOAL</td>
              </tr>
              
              <tr>
                <td><strong>DCTFWeb - SEM MOVIMENTO</strong></td>
                <td>Declaração de Débitos e Créditos Tributários Federais Web sem movimentação</td>
                <td class="text-center font-weight-bold">R$ 50,00 por ano</td>
              </tr>
              
              <tr>
                <td><strong>DCTFWeb - COM MOVIMENTO</strong></td>
                <td>Declaração de Débitos e Créditos Tributários Federais Web com movimentação</td>
                <td class="text-center font-weight-bold">R$ 100,00 por mês</td>
              </tr>
              
              <tr>
                <td><strong>FGTS</strong></td>
                <td>Fundo de Garantia por Tempo de Serviço</td>
                <td class="text-center font-weight-bold">R$ 100,00 por mês</td>
              </tr>
              
              <tr>
                <td><strong>GFIP - SEM MOVIMENTO</strong></td>
                <td>Guia de Recolhimento do FGTS e de Informações à Previdência Social sem movimentação</td>
                <td class="text-center font-weight-bold">R$ 100,00 por ano</td>
              </tr>
              
              <tr>
                <td><strong>GFIP - COM MOVIMENTO</strong></td>
                <td>Guia de Recolhimento do FGTS e de Informações à Previdência Social com movimentação</td>
                <td class="text-center font-weight-bold">R$ 100,00 por mês</td>
              </tr>
              
              <tr>
                <td><strong>Cálculo de Folha - SEM Variável</strong></td>
                <td>Cálculo de folha de pagamento sem componentes variáveis</td>
                <td class="text-center font-weight-bold">R$ 50,00 por funcionário/mês</td>
              </tr>
              
              <tr>
                <td><strong>Cálculo de Folha - COM Variável</strong></td>
                <td>Cálculo de folha de pagamento com componentes variáveis</td>
                <td class="text-center font-weight-bold">R$ 100,00 por funcionário/mês</td>
              </tr>
              
              <tr>
                <td><strong>Admissão</strong></td>
                <td>Processo de admissão de funcionário</td>
                <td class="text-center font-weight-bold">R$ 100,00 por funcionário</td>
              </tr>
              
              <tr>
                <td><strong>Rescisão</strong></td>
                <td>Processo de rescisão de contrato de trabalho</td>
                <td class="text-center font-weight-bold">R$ 200,00 por funcionário</td>
              </tr>
              
              <tr>
                <td><strong>Cálculo de Férias</strong></td>
                <td>Cálculo de férias e 13º salário</td>
                <td class="text-center font-weight-bold">R$ 200,00 por funcionário</td>
              </tr>
              
              <tr>
                <td><strong>Afastamento</strong></td>
                <td>Processamento de afastamentos (licenças, atestados, etc.)</td>
                <td class="text-center font-weight-bold">R$ 150,00 por funcionário</td>
              </tr>
            </tbody>
          </table>
        </div>
        
        <!-- Observações Importantes -->
        <div class="row mt-4">
          <div class="col-md-12">
            <div class="card border-warning">
              <div class="card-body">
                <h6 class="card-title text-warning"><i class="simple-icon-info mr-2"></i>Observações Importantes</h6>
                <ul class="mb-0">
                  <li>Os valores podem estar sujeitos a alteração mediante análise cadastral</li>
                  <li>Taxas dos órgãos públicos e despesas de correios e cartórios não estão inclusas</li>
                  <li>Prazos de entrega podem variar conforme a complexidade do serviço</li>
                  <li>Para serviços não listados, consulte nossa equipe comercial</li>
                  <li><strong>Serviços marcados em vermelho</strong> devem ser simulados no Sistema de Cálculo do Backoffice</li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<span id="output"></span>
</div>
</div><!-- end:row -->
</main>
<?php include_once("inc/footer.php") ?>
</body>
</html> 